<?php $__env->startSection('title'); ?>
    Site Information - Dashboard
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <style>
        .new-user{
            position: absolute;
            margin: -4px 0 0px 58px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0 text-dark">Website Info</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item active">Update Info</li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
        <div class="card card-success">
            <div class="card-header">
                <h3 class="card-title">Website Info Update</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form class="row" action="<?php echo e(route('admin.website.update',$website->id)); ?>" method="POST" enctype="multipart/form-data" >
                    <?php echo csrf_field(); ?>
                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Application Title</label>
                        <input type="text" class="form-control" id="title" name="title" value="<?php echo e($website->title); ?>" placeholder="Application Title">
                    </div>

                    <div class="form-group col-md-3 col-lg-3 col-12">
                        <label for="title">Site Email</label>
                        <input name="email" type="text" class="form-control" id="email" placeholder="Email Address"  value="<?php echo e($website->email); ?>">
                    </div>

                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Mobile No.</label>
                        <input name="mobile" type="text" class="form-control" id="mobile" placeholder="Mobile No"  value="<?php echo e($website->mobile); ?>" >
                    </div>

                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Phone No.</label>
                        <input name="phone" type="text" class="form-control" id="phone" placeholder="Phone No"  value="<?php echo e($website->phone); ?>" >
                    </div>

                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Reject Ratio</label>
                        <input name="job_work_reject_ratio" type="text" class="form-control" id="job_work_reject_ratio" placeholder="Reject Ration"  value="<?php echo e($website->job_work_reject_ratio); ?>" >
                    </div>

                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">User Block Ratio</label>
                        <input name="user_block_ratio" type="text" class="form-control" id="user_block_ratio" placeholder="Block Ration"  value="<?php echo e($website->user_block_ratio); ?>" >
                    </div>

                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Minimum Job Cost</label>
                        <input name="minimum_job_cost" type="text" class="form-control" id="minimum_job_cost" placeholder="Job Cost"  value="<?php echo e($website->minimum_job_cost); ?>" >
                    </div>
                    <!--***********************-->
                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Minimum Worker for Ads</label>
                        <input name="minimum_worker_ads" type="number" class="form-control" id="minimum_worker_ads" placeholder="Job Cost"  value="<?php echo e($website->minimum_worker_ads); ?>" >
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Minimum Duration for Ads</label>
                        <input name="minimum_duration_ads" type="text" class="form-control" id="minimum_duration_ads" placeholder="Job Cost"  value="<?php echo e($website->minimum_duration_ads); ?>" >
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Minimum Cost Per Worker for Ads</label>
                        <input name="minimum_cost_per_worker" type="text" class="form-control" id="minimum_cost_per_worker" placeholder="Job Cost"  value="<?php echo e($website->minimum_cost_per_worker); ?>" >
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-12">
                        <label for="title">Minimum Cost Per Duration (Second) for Ads</label>
                        <input name="minimum_cost_per_duration" type="text" class="form-control" id="minimum_cost_per_duration" placeholder="Job Cost"  value="<?php echo e($website->minimum_cost_per_duration); ?>" >
                    </div>
                    <!--***************************-->

                    <div class="form-group col-md-3 col-lg-3 col-12">
                        <label for="title">Referral Deposit Commision</label>
                        <input name="referral_deposit_commission" type="text" class="form-control" id="referral_deposit_commission" placeholder="Referral Deposit Commision"  value="<?php echo e($website->referral_deposit_commission); ?>" >
                    </div>

                    <div class="form-group col-md-3 col-lg-3 col-12">
                        <label for="title">Referral Earning Commision</label>
                        <input name="referral_earning_commission" type="text" class="form-control" id="referral_earning_commission" placeholder="Referral Earning Commision"  value="<?php echo e($website->referral_earning_commission); ?>" >
                    </div>
                    
                    <div class="form-group col-md-2">
                        <label for="instanat_verify_active">Instant Verfy</label>
                        <select class="form-control select2" name="instanat_verify_active">
                            <option value="1" <?php if($website->instanat_verify_active == 1): ?> selected <?php endif; ?>>Active</option>
                            <option value="0" <?php if($website->instanat_verify_active == 0): ?> selected <?php endif; ?>>Inactive</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-md-2">
                        <label for="need_user_verification">Need User Verification</label>
                        <select class="form-control select2" name="need_user_verification">
                            <option value="1" <?php if($website->need_user_verification == 1): ?> selected <?php endif; ?>>Yes</option>
                            <option value="0" <?php if($website->need_user_verification == 0): ?> selected <?php endif; ?>>No</option>
                        </select>
                    </div>

                    <div class="form-group col-md-2">
                        <label for="auto_approval_hour">Work Auto Approve</label>
                        <input name="auto_approval_hour" type="text" class="form-control" id="auto_approval_hour" placeholder="Hour"  value="<?php echo e($website->auto_approval_hour); ?>" >
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="title">Referral Notice</label>
                        <textarea name="referral_notice" class="form-control"  placeholder="Referral Notice" rows="2"><?php echo e($website->referral_notice); ?></textarea>
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="lottery_notice">Lottery Notice</label>
                        <textarea name="lottery_notice" class="form-control"  placeholder="Lottery Notice" rows="2"><?php echo e($website->lottery_notice); ?></textarea>
                    </div>

                    

                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Instant Deposit Note</label>
                        <textarea name="complete_task_note" class="form-control"  placeholder="Instant Deposit Note" rows="2"><?php echo e($website->complete_task_note); ?></textarea>
                    </div>

                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Account Verify Note</label>
                        <textarea name="accepted_task_note" class="form-control"  placeholder="User Account Verify Note" rows="2"><?php echo e($website->accepted_task_note); ?></textarea>
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="title">Description</label>
                        <textarea name="description" class="form-control"  placeholder="Description" rows="2"><?php echo e($website->description); ?> </textarea>
                    </div>

                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Meta Keyword</label>
                        <textarea name="meta_keyword" class="form-control"  placeholder="Meta Keyword" rows="2"><?php echo e($website->meta_keyword); ?></textarea>
                    </div>

                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Meta Description</label>
                        <textarea name="meta_tag" class="form-control"  placeholder="Meta Description" rows="2"><?php echo e($website->meta_tag); ?></textarea>
                    </div>

                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Address</label>
                        <textarea name="address" class="form-control"  placeholder="Address" rows="2"><?php echo e($website->address); ?></textarea>
                    </div>

                    

                    <div class="form-group col-lg-6 col-md-6 col-12">
                        <label for="title">Google Map</label>
                        <textarea name="google_map" class="form-control"  placeholder="Google Map" rows="2"><?php echo e($website->google_map); ?></textarea>
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="oldImage" class="control-label col-lg-2">Old Favicon Image</label>
                        <div class="input-group">
                            <img src="<?php echo e(URL::to($website->favicon)); ?>" class="thumb-lg img-circle img-thumbnail" alt="Site favicon" name="old_favicon" height="80px" width="80px">
                        </div>
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="exampleInputFile">Favicon Image</label>
                        <div class="input-group">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input upload" id="fevico" name="favicon" type="file" accept="image/*" onchange="readURL(this);">
                            <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                        </div>
                        <div class="input-group-append">
                            <span class="input-group-text" id="">Upload</span>
                        </div>
                        </div>
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="oldImage" class="control-label col-lg-2">Old Logo Image</label>
                        <div class="input-group">
                            <img src="<?php echo e(URL::to($website->logo)); ?>" class="thumb-lg img-circle img-thumbnail" alt="Site Logo" name="old_logo" height="80px" width="80px">
                        </div>
                    </div>

                    <div class="form-group col-lg-12 col-md-12 col-12">
                        <label for="exampleInputFile">Logo Image</label>
                        <div class="input-group">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input upload" id="image" name="logo" type="file" accept="image/*" onchange="readURL(this);">
                            <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                        </div>
                        <div class="input-group-append">
                            <span class="input-group-text" id="">Upload</span>
                        </div>
                        </div>
                    </div>

                    <!-- Additional fild -->
                    <table class="table table-striped">
                        <thead>
                            <tr class="bg-primary">
                                <th>Social icon ( https://fontawesome.com/v4.7.0/icons/ )</th>
                                <th>Link</th>
                                <th width="160" class="text-center">Add / Remove</th>
                            </tr>
                        </thead>
                        <tbody id="diagnosis">
                            <?php
                                $icon = explode("|",$website->icon);
                                $link = explode("|",$website->link);
                            ?>
                            <?php $__currentLoopData = $icon; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <input type="text" name="icon[]" autocomplete="off" class="form-control" placeholder="https://fontawesome.com/v4.7.0/icons/" value="<?php echo e($icon); ?>" >
                                </td>

                                <td>
                                    <input type="text" name="link[]" class="form-control" placeholder="https://" value="<?php if(isset($link[$key])): ?><?php echo e($link[$key]); ?><?php endif; ?>" >
                                </td>
                                <td class="text-center">
                                    <div class="btn btn-group">
                                    <button type="button" class="btn btn-sm btn-primary DiaAddBtn">+</button>
                                    <button type="button" class="btn btn-sm btn-danger DiaRemoveBtn">-</button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <!-- /.box-body -->

                    <div class="form-group row">
                        <div class="col-sm-6">
                            <div class="ui buttons">
                                <button type="submit" class="btn btn-success m-t-15 waves-effect">UPDATE</button>

                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Select2 -->
    <script src="<?php echo e(asset('backend/plugins/select2/js/select2.full.min.js')); ?>"></script>

    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>

    <script>
        $(function () {
          $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
          });
          $('#example2').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
          });
        });

        $(function () {
            $('.select2').select2();
        });

    </script>


<script>
    $(document).ready(function() {
      //#------------------------------------
      //   STARTS OF DIAGNOSIS
      //#------------------------------------
      //add row
      $('body').on('click','.DiaAddBtn' ,function() {
          var itemData = $(this).parent().parent().parent();
          $('#diagnosis').append("<tr>"+itemData.html()+"</tr>");
          $('#diagnosis tr:last-child').find(':input').val('');
      });
      //remove row
      $('body').on('click','.DiaRemoveBtn' ,function() {
          $(this).parent().parent().parent().remove();
      });

    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dealruom/microjob.dealingwork.com/resources/views/backend/pages/website/editwebsite.blade.php ENDPATH**/ ?>